//Files with predefined colors and textures
#include "colors.inc"
#include "glass.inc"
#include "golds.inc"
#include "metals.inc"
#include "stones.inc"
#include "woods.inc"
#include "textures.inc"

//Place the camera
camera {
  sky <0,0,1>           //Don't change this
  direction <-1,0,0>    //Don't change this  
  right <-4/3,0,0>      //Don't change this
  location <10,5,4.5> //Camera location
  //location <20,10,4.5> //Camera location
  look_at <0,.5,1.5>     //Where camera is pointing
  angle 15      //Angle of the view--increase to see more, decrease to see less
}

//Ambient light to "brighten up" darker pictures
global_settings { ambient_light White }

//Place a light--you can have more than one!
light_source {
  <10,5,20>   //Change this if you want to put the light at a different point
  color White*2.5         //Multiplying by 2 doubles the brightness
}
light_source {
  <1,1,1>   //Change this if you want to put the light at a different point
  color White         //Multiplying by 2 doubles the brightness
}

//Set a background color
background { color White }

//Create a "floor"
plane {
  <0,0,1>, 0            //This represents the plane 0x+0y+z=0
  pigment { checker color White, color Grey frequency 1}
}

//Hardware Sphere
difference {
  sphere { <0,0,1.5>, .05 }
  box { <0,0,1.5>, <2,2,4> }
  texture {T_Stone16}
}
//BIOS Password Sphere
difference {
  difference {
    sphere { <0,0,1.5>, .055 }
    sphere { <0,0,1.5>, .05 }
  }
  box { <0,0,1.5>, <2,2,4> }
  texture {T_Glass4}
  interior {I_Glass}
}

//GRUB Password Sphere
difference {
  difference {
    sphere { <0,0,1.5>, .075}
    sphere { <0,0,1.5>, .055 }
  }
  box { <0,0,1.5>, <2,2,4> }
  texture {T_Glass3}
  interior {I_Glass}
}

//Kernel Sphere
difference {
  difference {
    sphere { <0,0,1.5>, .175 }
    sphere { <0,0,1.5>, .075 }
  }
  box { <0,0,1.5>, <2,2,4> }
  pigment {Red}
}

//Encrypted File Systems Sphere
difference {
  difference {
    sphere { <0,0,1.5>, .200}
    sphere { <0,0,1.5>, .175 }
  }
  box { <0,0,1.5>, <2,2,4> }
  texture {T_Orange_Glass}
  interior {I_Glass}
}

//Libraries Sphere
difference {
  difference {
    sphere { <0,0,1.5>, .325 }
    sphere { <0,0,1.5>, .225 }
  }
  box { <0,0,1.5>, <2,2,4> }
  pigment {Yellow}
}

//HIPS Sphere
difference {
  difference {
    sphere { <0,0,1.5>, .350 }
    sphere { <0,0,1.5>, .325 }
  }
  box { <0,0,1.5>, <2,2,4> }
  texture {T_Yellow_Glass}
  interior {I_Glass}
}

//Permissions Sphere
difference {
  difference {
    sphere { <0,0,1.5>, .375 }
    sphere { <0,0,1.5>, .350 }
  }
  box { <0,0,1.5>, <2,2,4> }
  texture {T_Winebottle_Glass}
  interior {I_Glass}
}

//PAM Sphere
difference {
  difference {
    sphere { <0,0,1.5>, .400 }
    sphere { <0,0,1.5>, .375 }
  }
  box { <0,0,1.5>, <2,2,4> }
  texture {T_Green_Glass}
  interior {I_Glass}
}

//Apps Sphere
difference {
  difference {
    sphere { <0,0,1.5>, .550 }
    sphere { <0,0,1.5>, .450 }
  }
  box { <0,0,1.5>, <2,2,4> }
  pigment {Green}
}


//AppArmor Sphere
difference {
  difference {
    sphere { <0,0,1.5>, .575 }
    sphere { <0,0,1.5>, .425 }
  }
  box { <.01,.01,1.5>, <2,2,4> }
  texture {T_Dark_Green_Glass}
  interior {I_Glass}
}

//Modules Sphere
difference {
  difference {
    sphere { <0,0,1.5>, .700 }
    sphere { <0,0,1.5>, .600 }
  }
  box { <0,0,1.5>, <2,2,4> }
  pigment {Blue}
}


//Proxies Sphere
difference {
  difference {
    sphere { <0,0,1.5>, .800 }
    sphere { <0,0,1.5>, .750 }
  }
  box { <0,0,1.5>, <2,2,4> }
  texture {Aluminum}
}


//Firewalls Sphere
difference {
  difference {
    sphere { <0,0,1.5>, .90 }
    sphere { <0,0,1.5>, .85 }
  }
  box { <0,0,1.5>, <2,2,4> }
  texture {Gold_Metal}
}

//Limiters Sphere
difference {
  difference {
    sphere { <0,0,1.5>, 1 }
    sphere { <0,0,1.5>, .95 }
  }
  box { <0,0,1.5>, <2,2,4> }
  texture {Polished_Chrome}
}







#declare Tux_Tex =
   texture{pigment{color White}
           normal {bumps 0.4 scale 0.01}
           finish {ambient 0.45 diffuse 0.55 phong 0.1}}

#declare Tux_Tex1 =
   texture{pigment{color Black}
           normal {bumps 0.4 scale 0.01}
           finish {ambient 0.45 diffuse 0.55 phong 0.1}}

#declare Tux_Tex2 =
   texture{pigment{color Yellow}
           normal {bumps 0.4 scale 0.005}
           finish {ambient 0.45 diffuse 0.55 phong 0.1}}

#declare beak = union {
difference{
height_field {tga "beak1a.tga" smooth
texture {Tux_Tex2} }// scale<4,.75,4> }
box {<0,-1,0><1,0.2,1>
pigment {color rgbt<0,0,0,1>}}
scale<5,.5,3.5>
}//diff beak
difference{
height_field {tga "beak1a.tga" smooth
texture {Tux_Tex2} }// scale<4,.05,4> }
box {<0,-1,0><1,0.2,1>
pigment {color rgbt<0,0,0,1>}}
scale<5,.5,3.5>
}//diff beak
}//union

#declare beak2 = union {
difference{
height_field {tga "beak1a.tga" smooth
texture {Tux_Tex2} }// scale<4,.75,4> }
box {<0,-1,0><1,0.2,1>
pigment {color rgbt<0,0,0,1>}}
scale<5,.5,3.5> rotate 180*x
}//diff beak2
difference{
height_field {tga "beak1a.tga" smooth
texture {Tux_Tex2} }// scale<4,.05,4> }
box {<0,-1,0><1,0.2,1>
pigment {color rgbt<0,0,0,1>}}
scale<5,.5,3.5> rotate 180*x //rotate -25*z //-5*x 
}//diff beak2
}//union

#declare footl = union {
sphere {0 , 1 scale<.4,2,.4> texture {Tux_Tex1}
translate <2.5,2.1,1.5>}

difference {
height_field { tga "footl.tga" smooth
texture {Tux_Tex2} scale <5,.5,5> translate 0*x}
box {<0,-1,0><1,0,1>
pigment {color rgbt<0,0,0,1>}
scale 5 translate 0.05*y}
}//diff
difference {
height_field { tga "footl.tga" smooth
texture {Tux_Tex2} scale <5,.1,5> translate 0*x}
box {<0,-1,0><1,0,1>
pigment {color rgbt<0,0,0,1>}
scale 5 translate 0.05*y}
}//diff

}//union

#declare footr = union {
sphere {0 , 1 scale<.4,2,.4> texture {Tux_Tex1}
translate <2.5,2.1,1.5>}

difference {
height_field { tga "footr.tga" smooth
texture {Tux_Tex2} scale <5,.5,5> translate 0*x}
box {<0,-1,0><1,0,1>
pigment {color rgbt<0,0,0,1>}
scale 5 translate 0.05*y}
}//diff

difference {
height_field { tga "footr.tga" smooth
texture {Tux_Tex2} scale <5,.1,5> translate 0*x}
box {<0,-1,0><1,0,1>
pigment {color rgbt<0,0,0,1>}
scale 5 translate 0.05*y}
}//diff
}//union

#declare Tux_upperpart =
intersection{
 sphere{<0,0,0>,1 scale<1,1.75,1>}
 box{<-1,0,-1>,<1,1.75,1>}
 }

#declare Tux_lowerpart =
intersection{
 sphere{<0,0,0>,1 scale<1,1,1>}
 box{<-1,-1,-1>,<1,0,1>}
 }


#declare Tux = //belly
union{ object{Tux_upperpart}
       object{Tux_lowerpart}
       texture{Tux_Tex}
}

#declare Tux1 = //back
union{ object{Tux_upperpart}
       object{Tux_lowerpart}
       texture{Tux_Tex1}
}

#declare Tux_Bod = union {
object {Tux scale <1.25,1,1.25>*2.5 translate<0,0,-0.5>}
object {Tux1 scale <1.25,1,1.25>*2.5
scale 1.1
translate<0,0,0>}
}


#declare Tux_Head = union {

object {Tux1 rotate 180*z scale <1.5,1,1.5>
scale 1.5 translate<0,6.,0>}

sphere {0.0 , 1 texture{Tux_Tex} // left eye
scale <.5,.8,.5>
translate<-.7,4.7,-1.9> }

sphere {0.0 , 1 texture{Tux_Tex1} // left eye
scale <.5,.8,.5>*.5
translate<-.7,4.7,-2.3> }

sphere {0.0 , 1 texture{Tux_Tex} // right eye
scale <.5,.8,.5>
translate<.7,4.7,-1.9> }

sphere {0.0 , 1 texture{Tux_Tex1} // left eye
scale <.5,.8,.5>*.5
translate<.7,4.7,-2.3> }

}

#declare feet = union {
object {footl rotate <0,-0,0> translate <-4,-2,0>} //on right from front
object {footr rotate <0,+0,0> translate <-1,-2,0>}
}

//object {feet rotate <0,180,0> translate<0,-.5,0>} // feet below rules!

#declare beak3 = union {
object {beak rotate<0,90,0> translate <-1.75,4,0>}
object {beak2 rotate<0,90,0> translate <1.75,4,0>}
}

union {
  object {feet rotate <0,180,0> rotate <90,0,0> translate<0,-3.5,-3>}//sitting
  Tux_Bod
  Tux_Head
  beak3
  scale .1
  rotate <90,0,145>
  //translate<2,2,.25>
  translate<1.5,1.5,.25>
}

